/* HKCEE 1993 Paper II Q2 modified
YȵPC20iPAOHƦr0B1B2B3B4B5B6B7B8B9ܡA
ӧAMqCC}lɡAHNC3iPA
䤤3iPVWAo⪺3iPC
賣iܤPAΥH@isPN1β2iP@A
Mᥲqۤv3iPXiӡAھڤUCWhMwӭtG

Wh1Guv]YGPƭȬۦP^P
	uv]YGPƭȤP^Auv̳ӡC
Wh2GuvAIư]ƭȤW^̳ӡC
Wh3G賣APƭ`M̳ӡAPȫh@MסC

Descriptions:
	You and the computer are players in a game of 20 cards
	represented by no.s 0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9.
	At the start of the game, each player is given three cards at
	random with the third card face up so that each player knows
	the component's third card. ...
	...                  Then each player is required to select
	two cards from among his three cards. The winner is determined
	according to the following rules:
	    rule 1: When "a pair" (ie. 2 cards of the same no) and
	            no pair (ie. 2 cards of different no.s) are
	            compared, "a pair" wins;
	    rule 2: When two pairs are compared, the higher pair
	            (numerically) wins;
	    rule 3: When both players do not have a pair, the one
	            with the larger sum wins. If the sums are equal,
	            no one wins.

 Note: freq[] is used to store the history of the numbers drawn so far.
                 0   1   2   3   4   5   6   7   8   9
 e.g.  freq[]  | 1 | 0 | 0 | 2 | 0 | 1 | 0 | 0 | 0 | 2 |

       The no.s 0 and 5 have been drawn once.
       The no.s 3 and 9 have been drawn twice.
       The rest have not been drawn yet.

tasks:
(a) Write a procedure called CARD which
      i. generates a number n at random where 0<=n<=9
     ii. checks the history (freq[n]) to ensure that the number n has NOT been
         generated more than TWICE. If the number n has been generated twice
         (ie. the content of freq[n] is 2) generate another number n.
    iii. updates the history (ie. array freq[])

(b) Complete the procedure user_select2cards which accepts 2 no.s (x & y) from
    user where  i. x is different from y
               ii. x and y should fall in the range of 1 to 3
    sample screen:
	--------------------------------------------------------
	| Q: Which two cards do you select (1,2,3) ?   3   3   |
	|    Error - Select two different cards.               |
	| Q: Which two cards do you select (1,2,3) ?   9   8   |
	|    Error - Re-enter using 1, 2 or 3.                 |
	| Q: Which two cards do you select (1,2,3) ?   1   3   |
	--------------------------------------------------------
*/

#include <stdio.h>

int comp[3],	// q 3 cards held by computer
    user[3],	//  3 cards held by user
    freq[10];	// ȵPwƥ no.of of cards drawn so far
int CPair,YPair;	//  pair indicators: 1=true; 0=false
int CPoint,YPoint;	// I largest sum of any 2 cards
int cont;

int tryAgain(){
	char ans;
	do{
		fflush(stdin);
		printf("Try Again <Y/N> ? "); scanf("%c",&ans);
		ans=toupper(ans);
		if(ans!='Y' && ans!='N') printf("Enter Y or N\n");
	}while(ans!='Y' && ans!='N');
	return(ans=='Y');
}

void initArrays(){
	int i;
	for(i=0;i<10;i++) freq[i]=0;
	for(i=0;i<3;i++) comp[i]=-1;	// qP
	for(i=0;i<3;i++)  user[i]=-1;	// ̵P
}

int card(){
	int n;
	do{
		n=rand()%10;
	}while(freq[n]>1);
	freq[n]++;
	return n;
}

void displayCards(){
	printf(": \t%d\t%d\t%d\n",
			user[0],user[1],user[2]);
	printf("q: \tX\tX\t%d\n", comp[2]);
}

void draw3cards(){
	int i;
	for(i=0;i<3;i++) comp[i]=card();	// for computer
	for(i=0;i<3;i++) user[i]=card();	// for user
	displayCards();
}

void changeCard(){
	char ans;
	int choice;

	fflush(stdin);
	printf("nP <Y/N> ?  ");
	scanf("%c",&ans);
	ans=toupper(ans);

	if(ans=='Y'){
		do{
			fflush(stdin);
			printf("n@iP 0/1 ?  ");
			scanf("%d",&choice);
			if(choice<0 || choice>1)
				printf("~: пJ0,1!\n");
		}while(choice<0 || choice>1);
		user[choice]=card();
		displayCards();
	}
}

void user_select2cards (int *x, int *y){
	do{
		fflush(stdin);
		printf("пiP (0,1,2)?  ");
		scanf("%d%d",x,y);

		if(*x==*y)
			printf("пiPP\n");
		if(*x<0 || *x>2 || *y<0 || *y>2)
			printf("~: пJ 0,1,2!\n");
	}while(*x<0 || *x>2 || *y<0 || *y>2 || x==y);
}

void compareCards(){
	int i,x,y;
	user_select2cards(&x,&y);
	YPair=(user[x]==user[y]);
	YPoint = YPair*100 + (user[x]+user[y]);
	printf("̿F: \t%d\t%d\n",
			user[x],user[y]);

	//----- computer selects 2 cards -----
	CPair=0; x=0; y=1;
	if(comp[0]==comp[1]){
		comp[2]=comp[0]; CPair=1;   // make all 3 cards equal
	}
	if(comp[1]==comp[2]){
		comp[0]=comp[1]; CPair=1;
	}
	if(comp[2]==comp[0]){
		comp[1]=comp[0]; CPair=1;
	}

	if(CPair==0){
		x=0; y=2;
		CPoint = comp[0]+comp[2];
		for(i=0;i<2;i++)
			if(comp[i]+comp[i+1]>CPoint){
				x=i; y=i+1;
				CPoint = comp[x]+comp[y];
			}
	}

	CPoint = CPair*100 + (comp[x] + comp[y]);
	printf("qF: \t%d\t%d\n", comp[x],comp[y]);
}

main(){
	srand(time(NULL));
	do{
		initArrays();
		draw3cards();
		changeCard();
		compareCards();
		if(CPoint==YPoint)
			printf("M\n");
		else if(CPoint>YPoint)
			printf("q\n");
		else printf("̳\n");
	}while(tryAgain());

	system("pause");
	return 0;
}
