// HKCEE 1999 Paper II Qn 3
#include <stdio.h>
#include <time.h>

int box[6];
char turn[10];

void init(){
	int i;
	srand(time(NULL));
	for(i=0;i<6;i++) box[i]=2;
}

void applyRules(int n){
	int x=n-1,y=n+1;	// previous & next number
	if(x<0) x=5;
	if(y>5) y=0;        // y%=6;
	box[x]--;
	box[n]+=2;
	box[y]--;
}

void displayBox(){
	int i;
	printf("Box#:  0  1  2  3  4  5\n");
	printf("Value");
	for(i=0;i<6;i++) printf("%3d",box[i]);
	printf("\n");
}

int endGame(){
	int i, theEnd=0;
	for(i=0;i<6;i++)
		if(box[i]<0) theEnd=1;
	return theEnd;
}

void changePlayer(){
	if(strcmp(turn,"Player")==0)
		strcpy(turn,"Computer");
	else
		strcpy(turn,"Player");
}

main(){
	int n;
	init();
	displayBox();
	strcpy(turn,"Player");

	while(!endGame()){
		if(strcmp(turn,"Player")==0){
			printf("Press any key to roll the dice.\n");
			getch();
		}
		n = rand()%6;
		printf("\n%s rolls a %d.\n", turn,n);

		applyRules(n);
		displayBox();
		changePlayer();
	}
	printf("%s wins.\n",turn);
	system("pause");
	return 0;
}
